"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsGlobalStateCallOut = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/restore_snapshot_form/steps/step_logistics/data_streams_global_state_call_out.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  callout: {
    title: count => _i18n.i18n.translate('xpack.snapshotRestore.restoreForm.dataStreamsWarningCallOut.title', {
      defaultMessage: 'This snapshot contains {count, plural, one {a data stream} other {data streams}}',
      values: {
        count
      }
    }),
    body: docLink => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.dataStreamsWarningCallOut.body",
      defaultMessage: "Each data stream requires a matching index template. Please ensure any restored data streams have a matching index template. You can restore index templates by restoring the global cluster state. However, this may overwrite existing templates, cluster settings, ingest pipelines, and lifecycle policies. {learnMoreLink} about restoring snapshots that contain data streams.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: docLink,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 29,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.snapshotRestore.restoreForm.dataStreamsWarningCallOut.body.learnMoreLink', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 7
      }
    })
  }
};
const DataStreamsGlobalStateCallOut = ({
  dataStreamsCount
}) => {
  const {
    docLinks
  } = (0, _app_context.useCore)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "dataStreamWarningCallOut",
    title: i18nTexts.callout.title(dataStreamsCount),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, i18nTexts.callout.body(docLinks.links.snapshotRestore.createSnapshot));
};
exports.DataStreamsGlobalStateCallOut = DataStreamsGlobalStateCallOut;