"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadonlySettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/repository_form/type_settings/readonly_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReadonlySettings = ({
  repository,
  updateRepositorySettings,
  settingErrors
}) => {
  const {
    settings: {
      url
    }
  } = repository;
  const hasErrors = Boolean(Object.keys(settingErrors).length);
  function getSchemeHelpText(scheme) {
    switch (scheme) {
      case 'http':
      case 'https':
      case 'ftp':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlAllowedDescription",
          defaultMessage: "This URL must be registered in the {settingKey} setting.",
          values: {
            settingKey: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 53,
                columnNumber: 27
              }
            }, "repositories.url.allowed_urls")
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 11
          }
        });
      case 'file':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlFilePathDescription",
          defaultMessage: "This file location must be registered in the {settingKey} setting.",
          values: {
            settingKey: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 63,
                columnNumber: 27
              }
            }, "path.repo")
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 59,
            columnNumber: 11
          }
        });
      default:
        return null;
    }
  }
  const schemeOptions = [{
    value: 'http',
    text: 'http://'
  }, {
    value: 'https',
    text: 'https://'
  }, {
    value: 'ftp',
    text: 'ftp://'
  }, {
    value: 'file',
    text: 'file://'
  }];
  const [selectedScheme, selectScheme] = (0, _react.useState)(url ? url.split('://')[0] : 'http');
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlTitle",
      defaultMessage: "URL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlDescription",
      defaultMessage: "The location of the snapshots.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    })),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlSchemeLabel",
      defaultMessage: "Scheme",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 19
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: schemeOptions,
    value: selectedScheme,
    onChange: e => selectScheme(e.target.value),
    "aria-controls": "readonlyRepositoryUrlHelp",
    "data-test-subj": "schemeSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlLabel",
      defaultMessage: "Path (required)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 19
      }
    }),
    fullWidth: true,
    describedByIds: ['readonlyRepositoryUrlHelp'],
    isInvalid: Boolean(hasErrors && settingErrors.url),
    error: settingErrors.url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: Boolean(hasErrors && settingErrors.url),
    defaultValue: url ? url.split('://')[1] : '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        url: `${selectedScheme}://${e.target.value}`
      });
    },
    "data-test-subj": "urlInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
    id: "readonlyRepositoryUrlHelp",
    "aria-live": "polite",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, getSchemeHelpText(selectedScheme)))));
};
exports.ReadonlySettings = ReadonlySettings;