"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _validation = require("../../services/validation");
var _steps = require("./steps");
var _navigation = require("./navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/policy_form/policy_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyForm = ({
  policy: originalPolicy,
  dataStreams,
  indices,
  currentUrl,
  isEditing,
  isSaving,
  saveError,
  clearSaveError,
  onCancel,
  onSave
}) => {
  var _originalPolicy$reten, _originalPolicy$reten2;
  // Step state
  const [currentStep, setCurrentStep] = (0, _react.useState)(1);
  const [maxCompletedStep, setMaxCompletedStep] = (0, _react.useState)(0);
  const stepMap = {
    1: _steps.PolicyStepLogistics,
    2: _steps.PolicyStepSettings,
    3: _steps.PolicyStepRetention,
    4: _steps.PolicyStepReview
  };
  const CurrentStepForm = stepMap[currentStep];

  // Policy state
  const [policy, setPolicy] = (0, _react.useState)({
    ...originalPolicy,
    config: {
      // When creating a new policy includesGlobalState is enabled by default and the API will also
      // include all featureStates into the snapshot when this happens. We need to take this case into account
      // when creating the local state for the form and also set featureStates to be an empty array, which
      // for the API it means that it will include all featureStates.
      featureStates: [],
      // IncludeGlobalState is set as default by the api, so we want to replicate that behaviour in our
      // form state so that it gets explicitly represented in the request.
      includeGlobalState: true,
      ...(originalPolicy.config || {})
    },
    retention: {
      ...originalPolicy.retention,
      expireAfterUnit: (_originalPolicy$reten = (_originalPolicy$reten2 = originalPolicy.retention) === null || _originalPolicy$reten2 === void 0 ? void 0 : _originalPolicy$reten2.expireAfterUnit) !== null && _originalPolicy$reten !== void 0 ? _originalPolicy$reten : _constants.TIME_UNITS.DAY
    }
  });
  const isEditingManagedPolicy = Boolean(isEditing && policy.isManagedPolicy);

  // Policy validation state
  const [validation, setValidation] = (0, _react.useState)({
    isValid: true,
    errors: {}
  });
  const updatePolicy = (updatedFields, validationHelperData = {}) => {
    const newPolicy = {
      ...policy,
      ...updatedFields
    };
    const newValidation = (0, _validation.validatePolicy)(newPolicy, validationHelperData);
    setPolicy(newPolicy);
    setValidation(newValidation);
  };
  const updateCurrentStep = step => {
    if (maxCompletedStep < step - 1) {
      return;
    }
    setCurrentStep(step);
    setMaxCompletedStep(step - 1);
    clearSaveError();
  };
  const onBack = () => {
    const previousStep = currentStep - 1;
    setCurrentStep(previousStep);
    setMaxCompletedStep(previousStep - 1);
    clearSaveError();
  };
  const onNext = () => {
    if (!validation.isValid) {
      return;
    }
    const nextStep = currentStep + 1;
    setMaxCompletedStep(Math.max(currentStep, maxCompletedStep));
    setCurrentStep(nextStep);
  };
  const savePolicy = () => {
    if (validation.isValid) {
      onSave(policy);
    }
  };
  const lastStep = Object.keys(stepMap).length;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.PolicyNavigation, {
    currentStep: currentStep,
    maxCompletedStep: maxCompletedStep,
    updateCurrentStep: updateCurrentStep,
    isFormValid: validation.isValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CurrentStepForm, {
    policy: policy,
    indices: indices,
    dataStreams: dataStreams,
    updatePolicy: updatePolicy,
    isEditing: isEditing,
    currentUrl: currentUrl,
    errors: validation.errors,
    updateCurrentStep: updateCurrentStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }), saveError ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, saveError, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, currentStep > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    onClick: () => onBack(),
    disabled: !validation.isValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.backButtonLabel",
    defaultMessage: "Back",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 21
    }
  }))) : null, currentStep < lastStep ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "arrowRight",
    onClick: () => onNext(),
    iconSide: "right",
    disabled: !validation.isValid,
    "data-test-subj": "nextButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.nextButtonLabel",
    defaultMessage: "Next",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 21
    }
  }))) : null, currentStep === lastStep ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: !isEditingManagedPolicy,
    color: isEditingManagedPolicy ? 'warning' : 'success',
    iconType: "check",
    onClick: () => savePolicy(),
    isLoading: isSaving,
    "data-test-subj": "submitButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 19
    }
  }, isSaving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.savingButtonLabel",
    defaultMessage: "Saving\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 23
    }
  }) : isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.saveButtonLabel",
    defaultMessage: "Save policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 23
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.createButtonLabel",
    defaultMessage: "Create policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 23
    }
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onCancel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 7
    }
  }));
};
exports.PolicyForm = PolicyForm;