"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureStatesFormField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _app_context = require("../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/feature_states_form_field/feature_states_form_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FeatureStatesFormField = ({
  isLoadingFeatures = false,
  featuresOptions,
  selectedOptions,
  onUpdateFormSettings
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const optionsList = (0, _react.useMemo)(() => {
    if (!isLoadingFeatures) {
      const featuresList = featuresOptions.map(feature => ({
        label: feature
      }));
      return (0, _lodash.sortBy)(featuresList, 'label');
    }
    return [];
  }, [isLoadingFeatures, featuresOptions]);
  const onChange = selected => {
    onUpdateFormSettings({
      featureStates: selected.map(option => option.label)
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "featureStatesDropdown",
    placeholder: i18n.translate('xpack.snapshotRestore.featureStatesFormField.allFeaturesLabel', {
      defaultMessage: 'All features'
    }),
    options: optionsList,
    selectedOptions: selectedOptions,
    onChange: onChange,
    isLoading: isLoadingFeatures,
    isClearable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
};
exports.FeatureStatesFormField = FeatureStatesFormField;