"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchHistoricalSummary = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _historical_summary_client = require("../../services/historical_summary_client");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchHistoricalSummary = exports.fetchHistoricalSummary = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /internal/observability/slos/_historical_summary',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_read']
    }
  },
  params: _sloSchema.fetchHistoricalSummaryParamsSchema,
  handler: async ({
    request,
    logger,
    params,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient
    } = await getScopedClients({
      request,
      logger
    });
    const historicalSummaryClient = new _historical_summary_client.HistoricalSummaryClient(scopedClusterClient.asCurrentUser);
    return await historicalSummaryClient.fetch(params.body);
  }
});