"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSloBtn = CreateSloBtn;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _paths = require("../../../../../common/locators/paths");
var _use_permissions = require("../../../../hooks/use_permissions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/common/create_slo_btn.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CreateSloBtn() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const handleClickCreateSlo = () => {
    navigateToUrl(basePath.prepend(_paths.paths.sloCreate));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "slosPageCreateNewSloButton",
    disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested),
    fill: true,
    onClick: handleClickCreateSlo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.slo.sloList.pageHeader.create', {
    defaultMessage: 'Create SLO'
  }));
}