"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkPurgeRollupData = useBulkPurgeRollupData;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useBulkPurgeRollupData({
  onConfirm
} = {}) {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  return (0, _reactQuery.useMutation)(['bulkPurgeRollupData'], ({
    purgePolicy,
    force,
    list
  }) => {
    return sloClient.fetch('POST /api/observability/slos/_bulk_purge_rollup 2023-10-31', {
      params: {
        body: {
          purgePolicy,
          force,
          list
        }
      }
    });
  }, {
    onError: (error, {
      list
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.bulkPurge.errorNotification', {
          defaultMessage: 'Failed to schedule bulk purge of rollup data for {count} SLOs',
          values: {
            count: list.length
          }
        })
      });
    },
    onSuccess: (_, {
      list
    }) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.bulkPurge.successNotification', {
        defaultMessage: 'Bulk purge of rollup data scheduled for {count} SLOs',
        values: {
          count: list.length
        }
      }));
      onConfirm === null || onConfirm === void 0 ? void 0 : onConfirm();
    }
  });
}