"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsChartPanel = EventsChartPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _use_get_preview_data = require("../../../../hooks/use_get_preview_data");
var _use_kibana = require("../../../../hooks/use_kibana");
var _get_discover_link = require("../../utils/get_discover_link");
var _good_bad_events_chart = require("./good_bad_events_chart");
var _metric_timeslice_events_chart = require("./metric_timeslice_events_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/events_chart_panel/events_chart_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EventsChartPanel({
  slo,
  range,
  hideRangeDurationLabel = false,
  onBrushed
}) {
  var _slo$remote;
  const {
    discover,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const {
    isLoading,
    data
  } = (0, _use_get_preview_data.useGetPreviewData)({
    range,
    isValid: true,
    indicator: slo.indicator,
    groupings: slo.groupings,
    objective: slo.objective,
    remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName
  });
  const canLinkToDiscover = !['sli.apm.transactionErrorRate', 'sli.apm.transactionDuration'].includes(slo.indicator.type);
  function getChartTitle() {
    switch (slo.indicator.type) {
      case 'sli.metric.timeslice':
        return _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.timesliceTitle', {
          defaultMessage: 'Timeslice metric'
        });
      default:
        return _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.title', {
          defaultMessage: 'Good vs bad events'
        });
    }
  }
  function getChart() {
    var _data$results, _data$results2;
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
        size: "m",
        "data-test-subj": "eventsLoadingChart",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 14
        }
      });
    }
    switch (slo.indicator.type) {
      case 'sli.metric.timeslice':
        return /*#__PURE__*/_react.default.createElement(_metric_timeslice_events_chart.MetricTimesliceEventsChart, {
          slo: slo,
          data: (_data$results = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results !== void 0 ? _data$results : [],
          onBrushed: onBrushed,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 11
          }
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_good_bad_events_chart.GoodBadEventsChart, {
          data: (_data$results2 = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results2 !== void 0 ? _data$results2 : [],
          slo: slo,
          onBrushed: onBrushed,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 16
          }
        });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "eventsChartPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  }, getChartTitle()))), !hideRangeDurationLabel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.duration', {
    defaultMessage: 'Last 24h'
  })))), canLinkToDiscover && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    href: (0, _get_discover_link.getDiscoverLink)({
      slo,
      timeRange: {
        from: 'now-24h',
        to: 'now',
        mode: 'relative'
      },
      discover,
      uiSettings
    }),
    "data-test-subj": "sloDetailDiscoverLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    css: {
      marginRight: '4px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloDetails.viewEventsLink",
    defaultMessage: "View events",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, getChart())));
}