"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRulesForSlo = useFetchRulesForSlo;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchRulesForSlo({
  sloIds = []
}) {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.rule(sloIds),
    queryFn: async () => {
      try {
        const body = JSON.stringify({
          filter: sloIds.map(sloId => `alert.attributes.params.sloId:${sloId}`).join(' or '),
          per_page: 1000
        });
        const response = await http.post(`/internal/alerting/rules/_find`, {
          body
        });
        const rules = response.data.map(rule => (0, _public.transformRule)(rule));
        const init = sloIds.reduce((acc, sloId) => ({
          ...acc,
          [sloId]: []
        }), {});
        return rules.reduce((acc, rule) => ({
          ...acc,
          [rule.params.sloId]: acc[rule.params.sloId].concat(rule)
        }), init);
      } catch (error) {
        // ignore error for retrieving slos
      }
    },
    enabled: Boolean(sloIds.length),
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  const refetchRules = refetch;
  return {
    data,
    isLoading,
    isSuccess,
    isError,
    refetchRules
  };
}