"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchApmIndex = useFetchApmIndex;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchApmIndex() {
  const {
    apmSourcesAccess
  } = (0, _use_kibana.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchApmIndices'],
    queryFn: async ({
      signal
    }) => {
      try {
        var _response$metric;
        const response = await apmSourcesAccess.getApmIndices({
          signal
        });
        return (_response$metric = response.metric) !== null && _response$metric !== void 0 ? _response$metric : '';
      } catch (error) {
        // ignore error
      }
    },
    refetchOnWindowFocus: false
  });
  return {
    data: isInitialLoading ? '' : data !== null && data !== void 0 ? data : '',
    isLoading: isInitialLoading || isLoading || isRefetching,
    isSuccess,
    isError
  };
}