"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateRule = useCreateRule;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _use_kibana = require("./use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/hooks/use_create_burn_rate_rule.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function useCreateRule() {
  const {
    http,
    i18n: i18nStart,
    notifications: {
      toasts
    },
    theme
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useMutation)(['createRule'], ({
    rule
  }) => {
    try {
      const ruleId = (0, _uuid.v4)();
      const body = JSON.stringify(rule);
      return http.post(`${_common.BASE_ALERTING_API_PATH}/rule/${ruleId}`, {
        body
      });
    } catch (e) {
      throw new Error(`Unable to create burn rate rule: ${e}`);
    }
  }, {
    onMutate: async () => {
      const loadingToast = toasts.addInfo({
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "center",
          alignItems: "center",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.slo.rules.createRule.loadingNotification.descriptionText', {
          defaultMessage: 'Creating burn rate rule ...'
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 59,
            columnNumber: 17
          }
        }))), {
          i18n: i18nStart,
          theme
        })
      });
      return {
        loadingToastId: loadingToast.id
      };
    },
    onError: _err => {
      toasts.addDanger(_i18n.i18n.translate('xpack.slo.rules.createRule.errorNotification.descriptionText', {
        defaultMessage: 'Failed to create burn rate rule.'
      }));
    },
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.rules.createRule.successNotification.descriptionText', {
        defaultMessage: 'Burn rate rule created successfully.'
      }));
    },
    onSettled: (_d, _err, _res, ctx) => {
      if (ctx !== null && ctx !== void 0 && ctx.loadingToastId) {
        toasts.remove(ctx === null || ctx === void 0 ? void 0 : ctx.loadingToastId);
      }
    }
  });
}