"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsUrl = void 0;
var _common = require("@kbn/observability-plugin/common");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertsUrl = () => {
  const {
    basePath
  } = (0, _use_kibana.useKibana)().services.http;
  const kuery = 'kibana.alert.rule.rule_type_id:("slo.rules.burnRate")';
  return status => `${basePath.prepend(_common.observabilityPaths.alerts)}?_a=${_rison.default.encode({
    kuery,
    rangeFrom: 'now-24h',
    rangeTo: 'now',
    status
  })}`;
};
exports.useAlertsUrl = useAlertsUrl;