"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloStatusBadge = SloStatusBadge;
exports.displayStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/slo_badges/slo_status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const displayStatus = exports.displayStatus = {
  HEALTHY: {
    displayText: _i18n.i18n.translate('xpack.slo.sloStatusBadge.healthy', {
      defaultMessage: 'Healthy'
    }),
    badgeColor: 'success'
  },
  DEGRADING: {
    displayText: _i18n.i18n.translate('xpack.slo.sloStatusBadge.degrading', {
      defaultMessage: 'Degrading'
    }),
    badgeColor: 'warning'
  },
  VIOLATED: {
    displayText: _i18n.i18n.translate('xpack.slo.sloStatusBadge.violated', {
      defaultMessage: 'Violated'
    }),
    badgeColor: 'danger'
  },
  NO_DATA: {
    displayText: _i18n.i18n.translate('xpack.slo.sloStatusBadge.noData', {
      defaultMessage: 'No Data'
    }),
    badgeColor: 'default'
  }
};
function SloStatusBadge({
  slo,
  isLoading
}) {
  var _displayStatus$slo$su, _displayStatus$slo$su2;
  if (isLoading || !slo) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 2,
      "data-test-subj": "loadingTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, slo.summary.status === 'NO_DATA' ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.slo.sloStatusBadge.noDataTooltip', {
      defaultMessage: 'It may take some time before the data is aggregated and available.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: displayStatus[slo.summary.status].badgeColor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, (_displayStatus$slo$su = displayStatus[slo.summary.status]) === null || _displayStatus$slo$su === void 0 ? void 0 : _displayStatus$slo$su.displayText)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: displayStatus[slo.summary.status].badgeColor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, (_displayStatus$slo$su2 = displayStatus[slo.summary.status]) === null || _displayStatus$slo$su2 === void 0 ? void 0 : _displayStatus$slo$su2.displayText)), slo.summary.errorBudget.isEstimated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.slo.sloStatusBadge.forecasted', {
    defaultMessage: 'Forecasted'
  }))));
}