"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimeRangeAbsoluteTime = exports.getRelativeTimeValueAndUnitFromTimeString = exports.convertRelativeTimeStringToAbsoluteTimeString = exports.convertRelativeTimeStringToAbsoluteTimeDate = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const unitMap = new Map([['s', 'second'], ['m', 'minute'], ['h', 'hour'], ['d', 'day'], ['w', 'week'], ['M', 'month'], ['y', 'year']]);
const getRelativeTimeValueAndUnitFromTimeString = dateString => {
  if (!dateString) return;
  const mathPart = dateString.split('/')[0]; // Ignore rounding part for matching
  const roundingPart = dateString.includes('/') ? dateString.split('/')[1] : undefined;
  const match = mathPart.match(/^now([+-]\d+)([smhdwMy])$/);
  if (!match) return;
  const [, signAndNumber, unit] = match;
  return {
    value: Number(signAndNumber),
    unit: unitMap.get(unit),
    roundingUnit: roundingPart ? unitMap.get(roundingPart) : undefined
  };
};
exports.getRelativeTimeValueAndUnitFromTimeString = getRelativeTimeValueAndUnitFromTimeString;
const convertRelativeTimeStringToAbsoluteTimeDate = dateString => {
  if (!dateString) return;
  const valueParsed = _datemath.default.parse(dateString);
  return valueParsed !== null && valueParsed !== void 0 && valueParsed.isValid() ? valueParsed.toDate() : undefined;
};
exports.convertRelativeTimeStringToAbsoluteTimeDate = convertRelativeTimeStringToAbsoluteTimeDate;
const convertRelativeTimeStringToAbsoluteTimeString = dateString => {
  if (!dateString) return dateString;
  const valueParsed = _datemath.default.parse(dateString);
  return valueParsed && valueParsed.isValid() ? valueParsed.toISOString() : dateString;
};
exports.convertRelativeTimeStringToAbsoluteTimeString = convertRelativeTimeStringToAbsoluteTimeString;
const isTimeRangeAbsoluteTime = timeRange => {
  var _timeRange$from, _timeRange$to;
  return !(timeRange !== null && timeRange !== void 0 && (_timeRange$from = timeRange.from) !== null && _timeRange$from !== void 0 && _timeRange$from.includes('now') || timeRange !== null && timeRange !== void 0 && (_timeRange$to = timeRange.to) !== null && _timeRange$to !== void 0 && _timeRange$to.includes('now'));
};
exports.isTimeRangeAbsoluteTime = isTimeRangeAbsoluteTime;