"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeTypeSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _time_utils = require("../../../lib/time_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/tabs/link/time_type_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BoldText = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const boldText = (0, _react2.css)`
    font-weight: ${euiTheme.font.weight.bold};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: boldText,
    component: "span",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, children);
};
const AbsoluteTimeText = ({
  date
}) => {
  const absoluteDate = (0, _time_utils.convertRelativeTimeStringToAbsoluteTimeDate)(date);
  return /*#__PURE__*/_react.default.createElement(BoldText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
    value: absoluteDate,
    year: "numeric",
    month: "long",
    day: "2-digit",
    hour: "numeric",
    minute: "numeric",
    hour12: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
};
const RelativeTimeText = ({
  value,
  unit,
  roundingUnit
}) => /*#__PURE__*/_react.default.createElement(BoldText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, {
  value: value
  // @ts-expect-error - RelativeTimeFormatSingularUnit expected here is not exported so a cast from string is not possible
  ,
  unit: unit,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 5
  }
}), roundingUnit && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "share.link.timeRange.relativeTimeInfoText.roundingUnit",
  defaultMessage: " rounded to the {roundingUnit}",
  values: {
    roundingUnit
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 7
  }
}));
const getRelativeTimeText = timeRange => {
  // FormattedRelativeTime doesn't support "now" as a value, it will render "0 seconds" instead
  const from = (0, _time_utils.getRelativeTimeValueAndUnitFromTimeString)(timeRange.from);
  const to = (0, _time_utils.getRelativeTimeValueAndUnitFromTimeString)(timeRange.to);
  if (!(from !== null && from !== void 0 && from.value)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "relativeTimeInfoTextFromNow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.link.timeRange.relativeTimeInfoText.fromNow",
      defaultMessage: "The users will see all data from <bold>now</bold> to {to}, based on when they view it.",
      values: {
        to: /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
          value: to === null || to === void 0 ? void 0 : to.value,
          unit: to === null || to === void 0 ? void 0 : to.unit,
          roundingUnit: to === null || to === void 0 ? void 0 : to.roundingUnit,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 15
          }
        }),
        bold: chunks => /*#__PURE__*/_react.default.createElement(BoldText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 31
          }
        }, chunks)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }));
  }
  if (!(to !== null && to !== void 0 && to.value)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "relativeTimeInfoTextToNow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.link.timeRange.relativeTimeInfoText",
      defaultMessage: "The users will see all data from {from} to <bold>now</bold>, based on when they view it.",
      values: {
        from: /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
          value: from === null || from === void 0 ? void 0 : from.value,
          unit: from === null || from === void 0 ? void 0 : from.unit,
          roundingUnit: from === null || from === void 0 ? void 0 : from.roundingUnit,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 15
          }
        }),
        bold: chunks => /*#__PURE__*/_react.default.createElement(BoldText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 31
          }
        }, chunks)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "relativeTimeInfoTextDefault",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.timeRange.relativeTimeInfoText.default",
    defaultMessage: "The users will see all data from {from} to {to}, based on when they view it.",
    values: {
      from: /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
        value: from === null || from === void 0 ? void 0 : from.value,
        unit: from === null || from === void 0 ? void 0 : from.unit,
        roundingUnit: from === null || from === void 0 ? void 0 : from.roundingUnit,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 13
        }
      }),
      to: /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
        value: to === null || to === void 0 ? void 0 : to.value,
        unit: to === null || to === void 0 ? void 0 : to.unit,
        roundingUnit: to === null || to === void 0 ? void 0 : to.roundingUnit,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 13
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }));
};
const TimeTypeSection = ({
  timeRange,
  isAbsoluteTime,
  changeTimeType
}) => {
  const [isAbsoluteTimeByDefault, setIsAbsoluteTimeByDefault] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setIsAbsoluteTimeByDefault((0, _time_utils.isTimeRangeAbsoluteTime)(timeRange));
  }, [timeRange]);
  if (!timeRange) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isAbsoluteTimeByDefault && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('share.link.timeRange.switchLabel', {
      defaultMessage: 'Use absolute time range'
    }),
    checked: isAbsoluteTime,
    onChange: changeTimeType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, isAbsoluteTime ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "absoluteTimeInfoText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.timeRange.absoluteTimeInfoText",
    defaultMessage: "The users will see all data from {from} to {to}.",
    values: {
      from: /*#__PURE__*/_react.default.createElement(AbsoluteTimeText, {
        date: timeRange === null || timeRange === void 0 ? void 0 : timeRange.from,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 23
        }
      }),
      to: /*#__PURE__*/_react.default.createElement(AbsoluteTimeText, {
        date: timeRange === null || timeRange === void 0 ? void 0 : timeRange.to,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 21
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  })) : getRelativeTimeText(timeRange)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }), isAbsoluteTimeByDefault && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('share.link.timeRange.relativeTimeCallout', {
      defaultMessage: 'To use a relative time range, select it in the time picker first.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }));
};
exports.TimeTypeSection = TimeTypeSection;