"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareContextMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _url_panel_content = require("./url_panel_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/share_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Needed for Canvas
class ShareContextMenu extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getPanels", () => {
      const panels = [];
      const menuItems = [];
      const permalinkPanel = {
        id: panels.length + 1,
        title: _i18n.i18n.translate('share.contextMenu.permalinkPanelTitle', {
          defaultMessage: 'Get link'
        }),
        content: /*#__PURE__*/_react.default.createElement(_url_panel_content.UrlPanelContent, {
          allowShortUrl: this.props.allowShortUrl,
          objectId: this.props.objectId,
          objectType: this.props.objectType,
          shareableUrl: this.props.shareableUrl,
          shareableUrlForSavedObject: this.props.shareableUrlForSavedObject,
          shareableUrlLocatorParams: this.props.shareableUrlLocatorParams,
          anonymousAccess: this.props.anonymousAccess,
          showPublicUrlSwitch: this.props.showPublicUrlSwitch,
          urlService: this.props.urlService,
          snapshotShareWarning: this.props.snapshotShareWarning,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 9
          }
        })
      };
      menuItems.push({
        name: _i18n.i18n.translate('share.contextMenu.permalinksLabel', {
          defaultMessage: 'Get links'
        }),
        icon: 'link',
        panel: permalinkPanel.id,
        sortOrder: 0,
        disabled: Boolean(this.props.disabledShareUrl),
        // do not break functional tests
        'data-test-subj': 'Permalinks'
      });
      panels.push(permalinkPanel);
      if (this.props.allowEmbed) {
        const embedPanel = {
          id: panels.length + 1,
          title: _i18n.i18n.translate('share.contextMenu.embedCodePanelTitle', {
            defaultMessage: 'Embed Code'
          }),
          content: /*#__PURE__*/_react.default.createElement(_url_panel_content.UrlPanelContent, {
            allowShortUrl: this.props.allowShortUrl,
            isEmbedded: true,
            objectId: this.props.objectId,
            objectType: this.props.objectType,
            shareableUrl: this.props.shareableUrl,
            shareableUrlForSavedObject: this.props.shareableUrlForSavedObject,
            shareableUrlLocatorParams: this.props.shareableUrlLocatorParams,
            urlParamExtensions: this.props.embedUrlParamExtensions,
            anonymousAccess: this.props.anonymousAccess,
            showPublicUrlSwitch: this.props.showPublicUrlSwitch,
            urlService: this.props.urlService,
            snapshotShareWarning: this.props.snapshotShareWarning,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 106,
              columnNumber: 11
            }
          })
        };
        panels.push(embedPanel);
        menuItems.push({
          name: _i18n.i18n.translate('share.contextMenu.embedCodeLabel', {
            defaultMessage: 'Embed code'
          }),
          icon: 'console',
          panel: embedPanel.id,
          sortOrder: 0
        });
      }
      this.props.shareMenuItems.forEach(({
        shareMenuItem
      }) => {
        const panelId = panels.length + 1;
        panels.push({
          id: panelId
        });
        menuItems.push({
          ...shareMenuItem,
          name: shareMenuItem.name,
          panel: panelId
        });
      });
      if (menuItems.length > 1) {
        const topLevelMenuPanel = {
          id: panels.length + 1,
          title: _i18n.i18n.translate('share.contextMenuTitle', {
            defaultMessage: 'Share this {objectType}',
            values: {
              objectType: this.props.objectTypeTitle || this.props.objectType
            }
          }),
          items: menuItems
          // Sorts ascending on sort order first and then ascending on name
          .sort((a, b) => {
            const aSortOrder = a.sortOrder || 0;
            const bSortOrder = b.sortOrder || 0;
            if (aSortOrder > bSortOrder) {
              return 1;
            }
            if (aSortOrder < bSortOrder) {
              return -1;
            }
            if (a.name.toLowerCase().localeCompare(b.name.toLowerCase()) > 0) {
              return 1;
            }
            return -1;
          }).map(menuItem => {
            var _menuItem$dataTestS;
            menuItem['data-test-subj'] = `sharePanel-${(_menuItem$dataTestS = menuItem['data-test-subj']) !== null && _menuItem$dataTestS !== void 0 ? _menuItem$dataTestS : menuItem.name.replace(' ', '')}`;
            delete menuItem.sortOrder;
            return menuItem;
          })
        };
        panels.push(topLevelMenuPanel);
      }
      const lastPanelIndex = panels.length - 1;
      const initialPanelId = panels[lastPanelIndex].id;
      return {
        panels,
        initialPanelId
      };
    });
  }
  render() {
    const {
      panels,
      initialPanelId
    } = this.getPanels();
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: initialPanelId,
      panels: panels,
      "data-test-subj": "shareContextMenu",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }));
  }
}
exports.ShareContextMenu = ShareContextMenu;