"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSessionViewLazy = exports.getIndexPattern = exports.ENDPOINT_INDEX = exports.ELASTIC_DEFEND_DATA_SOURCE = exports.DEFAULT_INDEX = exports.AUDITBEAT_INDEX = exports.AUDITBEAT_DATA_SOURCE = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _analytics = require("@kbn/analytics");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/methods/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Initializing react-query
const queryClient = new _reactQuery.QueryClient();
const SessionViewLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/session_view'))));
const ELASTIC_DEFEND_DATA_SOURCE = exports.ELASTIC_DEFEND_DATA_SOURCE = 'endpoint';
const AUDITBEAT_DATA_SOURCE = exports.AUDITBEAT_DATA_SOURCE = 'auditbeat';
const SUPPORTED_PACKAGES = [ELASTIC_DEFEND_DATA_SOURCE, AUDITBEAT_DATA_SOURCE];
const INDEX_REGEX = new RegExp(`([a-z0-9_-]+\:)?[a-z0-9-.]*(${SUPPORTED_PACKAGES.join('|')})`, 'i');
const DEFAULT_INDEX = exports.DEFAULT_INDEX = 'logs-*';
const ENDPOINT_INDEX = exports.ENDPOINT_INDEX = 'logs-endpoint.events.process*';
const AUDITBEAT_INDEX = exports.AUDITBEAT_INDEX = 'auditbeat-*';
const sessionViewIntegrationIndices = {
  endpoint: ENDPOINT_INDEX,
  auditbeat: AUDITBEAT_INDEX
};

// Currently both logs-endpoint.events.process* and logs-cloud_defend.process* are valid sources for session data.
// To avoid cross cluster searches, the original index of the event is used to infer the index to find data for the
// rest of the session.
const getIndexPattern = eventIndex => {
  if (!eventIndex) {
    return DEFAULT_INDEX;
  }
  const match = eventIndex.match(INDEX_REGEX);
  const cluster = match === null || match === void 0 ? void 0 : match[1];
  const clusterStr = cluster ? `${cluster}` : '';
  const service = match === null || match === void 0 ? void 0 : match[2];
  const index = service ? sessionViewIntegrationIndices[service] : DEFAULT_INDEX;
  return clusterStr + index;
};
exports.getIndexPattern = getIndexPattern;
const getSessionViewLazy = props => {
  const index = getIndexPattern(props.index);
  const trackEvent = key => {
    if (props.usageCollection) {
      props.usageCollection.reportUiCounter(_constants.USAGE_COLLECTION_APP_NAME, _analytics.METRIC_TYPE.CLICK, key);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 27
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SessionViewLazy, (0, _extends2.default)({}, props, {
    index: index,
    trackEvent: trackEvent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }))));
};
exports.getSessionViewLazy = getSessionViewLazy;