"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiTheme = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Borealis migration - euiLightVars and euiDarkVars are depricated.
// Options: lock <EuiThemeProvider colorMode="dark"> or use hardcoded colors outside of theme colors

// Not all Eui Tokens were fully migrated to @elastic/eui/useEuiTheme yet, so
// this hook overrides the default useEuiTheme hook to provide a custom hook that
// allows the use the euiVars tokens from the euiLightVars and euiDarkVars
const useEuiTheme = (...props) => {
  const euiThemeHook = (0, _eui.useEuiTheme)(...props);
  const euiVars = (0, _react.useMemo)(() => {
    const extraEuiVars = {
      // Terminal Output Colors don't change with the theme
      terminalOutputBackground: '#1d1e23',
      // TODO: Borealis migration - replace with proper color token
      terminalOutputMarkerAccent: _uiTheme.euiLightVars.euiColorAccent,
      terminalOutputMarkerWarning: _uiTheme.euiDarkVars.euiColorWarning,
      terminalOutputSliderBackground: _uiTheme.euiLightVars.euiColorDarkestShade
    };
    return {
      ...extraEuiVars
    };
  }, []);
  return {
    ...euiThemeHook,
    euiVars
  };
};
exports.useEuiTheme = useEuiTheme;