"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = ({
  height = 500
}) => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      border,
      size
    } = euiTheme;

    // 118px = Session View Toolbar height + Close Session button height + spacing margin at the bottom
    const sessionView = {
      height: `${height + 'px'}`
    };
    const processTree = {
      ...sessionView,
      position: 'relative'
    };
    const nonGrowGroup = {
      display: 'flex',
      flexGrow: 0,
      alignItems: 'stretch'
    };
    const sessionViewerComponent = {
      position: 'relative',
      border: border.thin,
      borderRadius: border.radius.medium,
      '> .sessionViewerToolbar': {
        backgroundColor: `${euiTheme.components.forms.backgroundDisabled}`,
        padding: `${size.m} ${size.base}`
      }
    };
    const fakeDisabled = {
      color: euiTheme.colors.backgroundBaseDisabled
    };
    return {
      processTree,
      nonGrowGroup,
      fakeDisabled,
      sessionViewerComponent
    };
  }, [euiTheme, height]);
  return cached;
};
exports.useStyles = useStyles;