"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelProcessTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _detail_panel_accordion = require("../detail_panel_accordion");
var _detail_panel_copy = require("../detail_panel_copy");
var _detail_panel_description_list = require("../detail_panel_description_list");
var _detail_panel_list_item = require("../detail_panel_list_item");
var _data_or_dash = require("../../utils/data_or_dash");
var _helpers = require("./helpers");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/detail_panel_process_tab/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Update placeholder descriptions for these tootips once UX Writer Team Defines them
const leaderDescriptionListInfo = [{
  id: 'processEntryLeader',
  title: 'Entry Leader',
  tooltipContent: _i18n.i18n.translate('xpack.sessionView.detailPanel.entryLeaderTooltip', {
    defaultMessage: 'Session leader process associated with initial terminal or remote access via SSH, SSM and other remote access protocols. Entry sessions are also used to represent a service directly started by the init process. In many cases this is the same as the session_leader.'
  })
}, {
  id: 'processSessionLeader',
  title: 'Session Leader',
  tooltipContent: _i18n.i18n.translate('xpack.sessionView.detailPanel.sessionLeaderTooltip', {
    defaultMessage: 'Often the same as entry_leader. When it differs, this represents a session started within another session. Some tools like tmux and screen will start a new session to obtain a new tty and/or separate their lifecycle from the entry session.'
  })
}, {
  id: 'processGroupLeader',
  title: 'Group Leader',
  tooltipContent: _i18n.i18n.translate('xpack.sessionView.detailPanel.processGroupLeaderTooltip', {
    defaultMessage: 'The process group leader to the current process.'
  })
}, {
  id: 'processParent',
  title: 'Parent',
  tooltipContent: _i18n.i18n.translate('xpack.sessionView.detailPanel.processParentTooltip', {
    defaultMessage: 'The direct parent to the current process.'
  })
}];
const PROCESS_FIELD_PREFIX = 'process';
const LEADER_FIELD_PREFIX = [`${PROCESS_FIELD_PREFIX}.entry_leader`, `${PROCESS_FIELD_PREFIX}.session_leader`, `${PROCESS_FIELD_PREFIX}.group_leader`, `${PROCESS_FIELD_PREFIX}.parent`];

/**
 * Detail panel in the session view.
 */
const DetailPanelProcessTab = ({
  selectedProcess,
  index
}) => {
  const styles = (0, _styles.useStyles)();
  const processDetail = (0, _react.useMemo)(() => (0, _helpers.getDetailPanelProcess)(selectedProcess, index), [selectedProcess, index]);
  const renderExecs = (0, _react.useCallback)(executable => executable.map((execTuple, idx) => {
    const [exec, eventAction] = execTuple;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: `executable-${idx}`,
      css: styles.ellipsis,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default",
      css: styles.descriptionSemibold,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }, exec), eventAction && /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default",
      css: styles.executableAction,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    }, eventAction));
  }), [styles.descriptionSemibold, styles.ellipsis, styles.executableAction]);
  const leaderListItems = [processDetail.entryLeader, processDetail.sessionLeader, processDetail.groupLeader, processDetail.parent].map((leader, idx) => {
    const {
      id,
      start,
      end,
      exitCode,
      entryMetaType,
      interactive,
      workingDirectory,
      args,
      executable,
      pid,
      userId,
      userName,
      groupId,
      groupName,
      entryMetaSourceIp
    } = leader;
    const leaderExecutableText = (0, _helpers.getProcessExecutableCopyText)(executable);
    const listItems = [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 16
        }
      }, "entity_id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.entity_id: "${id}"`,
        tooltipContent: id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 11
        }
      }, id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 16
        }
      }, "args"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.args: "${args}"`,
        tooltipContent: args,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 11
        }
      }, args)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 16
        }
      }, "executable"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.executable: "${leaderExecutableText}"`,
        tooltipContent: leaderExecutableText,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 11
        }
      }, renderExecs(executable))
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 16
        }
      }, "interactive"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.interactive: "${interactive}"`,
        tooltipContent: interactive,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 11
        }
      }, interactive)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 16
        }
      }, "working_directory"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.working_directory: "${workingDirectory}"`,
        tooltipContent: workingDirectory,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 11
        }
      }, workingDirectory)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 16
        }
      }, "pid"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.pid: "${pid}"`,
        tooltipContent: pid,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 11
        }
      }, pid)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 16
        }
      }, "start"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.start: "${start}"`,
        tooltipContent: start,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 11
        }
      }, start)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 16
        }
      }, "end"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.end: "${end}"`,
        tooltipContent: end,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 11
        }
      }, end)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 16
        }
      }, "exit_code"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.exit_code: "${exitCode}"`,
        tooltipContent: exitCode,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 11
        }
      }, exitCode)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 16
        }
      }, "user.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.user.id: "${userId}"`,
        tooltipContent: userId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 230,
          columnNumber: 11
        }
      }, userId)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 16
        }
      }, "user.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.user.name: "${userName}"`,
        tooltipContent: userName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 11
        }
      }, userName)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 250,
          columnNumber: 16
        }
      }, "group.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.group.id: "${groupId}"`,
        tooltipContent: groupId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 252,
          columnNumber: 11
        }
      }, groupId)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 16
        }
      }, "group.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${LEADER_FIELD_PREFIX[idx]}.group.name: "${groupName}"`,
        tooltipContent: groupName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 263,
          columnNumber: 11
        }
      }, groupName)
    }];
    // Only include entry_meta.type and entry_meta.source.ip for entry leader
    if (idx === 0) {
      listItems.push({
        title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 276,
            columnNumber: 18
          }
        }, "entry_meta.type"),
        description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
          textToCopy: `${LEADER_FIELD_PREFIX[idx]}.entry_meta.type: "${entryMetaType}"`,
          tooltipContent: entryMetaType,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 278,
            columnNumber: 13
          }
        }, entryMetaType)
      }, {
        title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 287,
            columnNumber: 18
          }
        }, "entry_meta.source.ip"),
        description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
          textToCopy: `${LEADER_FIELD_PREFIX[idx]}.entry_meta.source.ip: "${entryMetaSourceIp}"`,
          tooltipContent: entryMetaSourceIp,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 289,
            columnNumber: 13
          }
        }, (0, _data_or_dash.dataOrDash)(entryMetaSourceIp))
      });
    }
    return {
      ...leaderDescriptionListInfo[idx],
      name: leader.name,
      listItems
    };
  });
  const {
    id,
    start,
    end,
    executable,
    exitCode,
    pid,
    workingDirectory,
    interactive,
    userId,
    userName,
    groupId,
    groupName,
    args
  } = processDetail;
  const executableText = (0, _helpers.getProcessExecutableCopyText)(executable);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detail_panel_description_list.DetailPanelDescriptionList, {
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 20
        }
      }, "entity_id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.entity_id: "${id}"`,
        tooltipContent: id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 331,
          columnNumber: 15
        }
      }, id)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 340,
          columnNumber: 20
        }
      }, "args"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.args: "${args}"`,
        tooltipContent: args,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 342,
          columnNumber: 15
        }
      }, args)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 351,
          columnNumber: 20
        }
      }, "executable"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.executable: "${executableText}"`,
        tooltipContent: executableText,
        display: "block",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 353,
          columnNumber: 15
        }
      }, renderExecs(executable))
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 363,
          columnNumber: 20
        }
      }, "interactive"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.interactive: "${interactive}"`,
        tooltipContent: interactive,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 15
        }
      }, interactive)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 374,
          columnNumber: 20
        }
      }, "working_directory"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.working_directory: "${workingDirectory}"`,
        tooltipContent: workingDirectory,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 376,
          columnNumber: 15
        }
      }, workingDirectory)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 385,
          columnNumber: 20
        }
      }, "pid"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.pid: "${pid}"`,
        tooltipContent: pid,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 387,
          columnNumber: 15
        }
      }, pid)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 396,
          columnNumber: 20
        }
      }, "start"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.start: "${start}"`,
        tooltipContent: start,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 15
        }
      }, start)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 407,
          columnNumber: 20
        }
      }, "end"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.end: "${end}"`,
        tooltipContent: end,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 409,
          columnNumber: 15
        }
      }, end)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 418,
          columnNumber: 20
        }
      }, "exit_code"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.exit_code: "${exitCode}"`,
        tooltipContent: exitCode,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 420,
          columnNumber: 15
        }
      }, exitCode)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 429,
          columnNumber: 20
        }
      }, "user.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.user.id: "${userId}"`,
        tooltipContent: userId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 431,
          columnNumber: 15
        }
      }, userId)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 440,
          columnNumber: 20
        }
      }, "user.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.user.name: "${userName}"`,
        tooltipContent: userName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 442,
          columnNumber: 15
        }
      }, userName)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 451,
          columnNumber: 20
        }
      }, "group.id"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.group.id: "${groupId}"`,
        tooltipContent: groupId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 453,
          columnNumber: 15
        }
      }, groupId)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 462,
          columnNumber: 20
        }
      }, "group.name"),
      description: /*#__PURE__*/_react.default.createElement(_detail_panel_copy.DetailPanelCopy, {
        textToCopy: `${PROCESS_FIELD_PREFIX}.group.name: "${groupName}"`,
        tooltipContent: groupName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 464,
          columnNumber: 15
        }
      }, groupName)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 7
    }
  }), leaderListItems.map(leader => /*#__PURE__*/_react.default.createElement(_detail_panel_accordion.DetailPanelAccordion, {
    key: leader.id,
    id: leader.id,
    title: leader.title,
    tooltipContent: leader.tooltipContent,
    listItems: leader.listItems,
    extraActionTitle: leader.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 9
    }
  })));
};
exports.DetailPanelProcessTab = DetailPanelProcessTab;