"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateManageOrgMembersNavCard = generateManageOrgMembersNavCard;
exports.manageOrgMembersNavCardName = void 0;
var _i18n = require("@kbn/i18n");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const manageOrgMembersNavCardName = exports.manageOrgMembersNavCardName = 'organization_members';
function generateManageOrgMembersNavCard(cloudOrgUrl) {
  return {
    category: _managementCardsNavigation.appCategories.ACCESS,
    description: _i18n.i18n.translate('xpack.serverless.nav.manageOrgMembersDescription', {
      defaultMessage: 'Invite team members and assign them roles to access this project.'
    }),
    icon: 'users',
    skipValidation: true,
    href: cloudOrgUrl !== null && cloudOrgUrl !== void 0 ? cloudOrgUrl : '',
    title: _i18n.i18n.translate('xpack.serverless.nav.manageOrgMembersTitle', {
      defaultMessage: 'Manage organization members'
    })
  };
}