"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndices = fetchIndices;
var _is_not_nullish = require("../../../common/utils/is_not_nullish");
var _index_utils = require("../../utils/index_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchIndices(client, from, size, searchQuery) {
  const indexPattern = searchQuery ? `*${searchQuery}*` : '*';
  const indexMatches = await client.indices.get({
    expand_wildcards: ['open'],
    // for better performance only compute settings of indices but not mappings
    features: ['aliases', 'settings'],
    index: indexPattern
  });
  const indexNames = Object.keys(indexMatches).filter(indexName => indexMatches[indexName] && !(0, _index_utils.isHidden)(indexMatches[indexName]) && !(0, _index_utils.isClosed)(indexMatches[indexName]));
  const indexNameSlice = indexNames.slice(from, from + size).filter(_is_not_nullish.isNotNullish);
  if (indexNameSlice.length === 0) {
    return [];
  }
  return indexNameSlice.map(name => ({
    name
  }));
}