"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeZodValidationObject = makeZodValidationObject;
var _zodHelpers = require("@kbn/zod-helpers");
var _validation_objects = require("./validation_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function makeZodValidationObject(params) {
  return {
    params: params.shape.path ? asStrict(params.shape.path) : _validation_objects.noParamsValidationObject.params,
    query: params.shape.query ? asStrict(params.shape.query) : _validation_objects.noParamsValidationObject.query,
    body: params.shape.body ? asStrict(params.shape.body) : _validation_objects.noParamsValidationObject.body
  };
}
function asStrict(schema) {
  return (0, _zodHelpers.DeepStrict)(schema);
}