"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseEsqlQuery = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _compute_if_esql_query_aggregating = require("./compute_if_esql_query_aggregating");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * check if esql query valid for Security rule:
 * - if it's non aggregation query it must have metadata operator
 */
const parseEsqlQuery = query => {
  const {
    root,
    errors
  } = (0, _esqlAst.parse)(query);
  const isEsqlQueryAggregating = (0, _compute_if_esql_query_aggregating.isAggregatingQuery)(root);
  return {
    errors,
    isEsqlQueryAggregating,
    hasMetadataOperator: computeHasMetadataOperator(root)
  };
};

/**
 * checks whether query has metadata _id operator
 */
exports.parseEsqlQuery = parseEsqlQuery;
function computeHasMetadataOperator(astExpression) {
  // Check whether the `from` command has `metadata` operator
  const metadataOption = getMetadataOption(astExpression);
  if (!metadataOption) {
    return false;
  }

  // Check whether the `metadata` operator has `_id` argument
  const idColumnItem = metadataOption.args.find(fromArg => (0, _esqlAst.isColumn)(fromArg) && fromArg.name === '_id');
  if (!idColumnItem) {
    return false;
  }
  return true;
}
function getMetadataOption(astExpression) {
  const fromCommand = astExpression.commands.find(x => x.name === 'from');
  if (!(fromCommand !== null && fromCommand !== void 0 && fromCommand.args)) {
    return undefined;
  }

  // Check whether the `from` command has `metadata` operator
  for (const fromArg of fromCommand.args) {
    if ((0, _esqlAst.isOptionNode)(fromArg) && fromArg.name === 'metadata') {
      return fromArg;
    }
  }
  return undefined;
}