"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAggregatingQuery = exports.computeIsESQLQueryAggregating = void 0;
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAggregatingQuery = astExpression => astExpression.commands.some(command => command.name === 'stats');

/**
 * compute if esqlQuery is aggregating/grouping, i.e. using STATS...BY command
 * @param esqlQuery
 * @returns boolean
 */
exports.isAggregatingQuery = isAggregatingQuery;
const computeIsESQLQueryAggregating = esqlQuery => {
  const {
    root
  } = (0, _esqlAst.parse)(esqlQuery);
  return isAggregatingQuery(root);
};
exports.computeIsESQLQueryAggregating = computeIsESQLQueryAggregating;