"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createListSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _name = require("../../common/name");
var _description = require("../../common/description");
var _type = require("../../common/type");
var _deserializer = require("../../common/deserializer");
var _id = require("../../common/id");
var _meta = require("../../common/meta");
var _serializer = require("../../common/serializer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createListSchema = exports.createListSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  name: _name.name,
  type: _type.type
})), t.exact(t.partial({
  deserializer: _deserializer.deserializer,
  // defaults to undefined if not set during decode
  id: _id.id,
  // defaults to undefined if not set during decode
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  serializer: _serializer.serializer,
  // defaults to undefined if not set during decode
  version: _securitysolutionIoTsTypes.DefaultVersionNumber // defaults to a numerical 1 if not set during decode
}))]);