"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.telemetryEvents = exports.NLP_CLEANUP_TASK_EVENT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NLP_CLEANUP_TASK_EVENT = exports.NLP_CLEANUP_TASK_EVENT = {
  eventType: 'nlp_cleanup_task',
  schema: {
    message: {
      type: 'keyword',
      _meta: {
        description: 'General message from task completion, either summary of task or error message'
      }
    },
    productTier: {
      type: 'keyword',
      _meta: {
        description: 'Current productTier when task was run'
      }
    },
    failedToDeleteCount: {
      type: 'long',
      _meta: {
        description: 'Total number of NLP models failed to be cleaned up'
      }
    },
    totalInstalledCount: {
      type: 'long',
      _meta: {
        description: 'Total number of NLP models deployed when task started'
      }
    }
  }
};
const telemetryEvents = exports.telemetryEvents = [NLP_CLEANUP_TASK_EVENT];