"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pickSavedTimeline = void 0;
var _fp = require("lodash/fp");
var _userProfileComponents = require("@kbn/user-profile-components");
var _constants = require("../../../../../common/constants");
var _timeline = require("../../../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pickSavedTimeline = (timelineId, savedTimeline, userInfo) => {
  var _savedTimeline$exclud;
  const dateNow = new Date().valueOf();
  if (timelineId == null) {
    savedTimeline.created = dateNow;
    savedTimeline.createdBy = userInfo ? (0, _userProfileComponents.getUserDisplayName)(userInfo) : _constants.UNAUTHENTICATED_USER;
    savedTimeline.updated = dateNow;
    savedTimeline.updatedBy = userInfo ? (0, _userProfileComponents.getUserDisplayName)(userInfo) : _constants.UNAUTHENTICATED_USER;
  } else if (timelineId != null) {
    savedTimeline.updated = dateNow;
    savedTimeline.updatedBy = userInfo ? (0, _userProfileComponents.getUserDisplayName)(userInfo) : _constants.UNAUTHENTICATED_USER;
  }
  if (savedTimeline.status === _timeline.TimelineStatusEnum.draft || savedTimeline.status == null) {
    savedTimeline.status = !(0, _fp.isEmpty)(savedTimeline.title) ? _timeline.TimelineStatusEnum.active : _timeline.TimelineStatusEnum.draft;
  }
  if (savedTimeline.timelineType === _timeline.TimelineTypeEnum.default) {
    var _savedTimeline$timeli, _savedTimeline$status;
    savedTimeline.timelineType = (_savedTimeline$timeli = savedTimeline.timelineType) !== null && _savedTimeline$timeli !== void 0 ? _savedTimeline$timeli : _timeline.TimelineTypeEnum.default;
    savedTimeline.status = (_savedTimeline$status = savedTimeline.status) !== null && _savedTimeline$status !== void 0 ? _savedTimeline$status : _timeline.TimelineStatusEnum.active;
    savedTimeline.templateTimelineId = null;
    savedTimeline.templateTimelineVersion = null;
  }
  if (!(0, _fp.isEmpty)(savedTimeline.title) && savedTimeline.status === _timeline.TimelineStatusEnum.draft) {
    savedTimeline.status = _timeline.TimelineStatusEnum.active;
  }
  savedTimeline.excludedRowRendererIds = (_savedTimeline$exclud = savedTimeline.excludedRowRendererIds) !== null && _savedTimeline$exclud !== void 0 ? _savedTimeline$exclud : [];
  return savedTimeline;
};
exports.pickSavedTimeline = pickSavedTimeline;