"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteNoteRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../common/constants");
var _utils = require("../../../detection_engine/routes/utils");
var _common = require("../../utils/common");
var _timeline = require("../../../../../common/api/timeline");
var _notes = require("../../saved_object/notes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteNoteRoute = router => {
  router.versioned.delete({
    path: _constants.NOTE_URL,
    security: {
      authz: {
        requiredPrivileges: ['notes_write']
      }
    },
    access: 'public'
  }).addVersion({
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_timeline.DeleteNoteRequestBody)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, request);
      if (!request.body) {
        throw new Error('Missing request body');
      }
      let noteIds = [];
      if ('noteId' in request.body) {
        noteIds = [request.body.noteId];
      } else if ('noteIds' in request.body && Array.isArray(request.body.noteIds)) {
        noteIds = request.body.noteIds;
      }
      await (0, _notes.deleteNote)({
        request: frameworkRequest,
        noteIds
      });
      return response.ok();
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.deleteNoteRoute = deleteNoteRoute;