"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationTaskEvaluator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fastestLevenshtein = require("fastest-levenshtein");
var _siem_migrations_task_evaluator = require("../../common/task/siem_migrations_task_evaluator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleMigrationTaskEvaluator extends _siem_migrations_task_evaluator.SiemMigrationsBaseEvaluator {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "evaluators", {
      custom_query_accuracy: ({
        run,
        example
      }) => {
        var _run$outputs, _run$outputs$elastic_, _example$outputs, _example$outputs$elas;
        const runQuery = run === null || run === void 0 ? void 0 : (_run$outputs = run.outputs) === null || _run$outputs === void 0 ? void 0 : (_run$outputs$elastic_ = _run$outputs.elastic_rule) === null || _run$outputs$elastic_ === void 0 ? void 0 : _run$outputs$elastic_.query;
        const expectedQuery = example === null || example === void 0 ? void 0 : (_example$outputs = example.outputs) === null || _example$outputs === void 0 ? void 0 : (_example$outputs$elas = _example$outputs.elastic_rule) === null || _example$outputs$elas === void 0 ? void 0 : _example$outputs$elas.query;
        if (!expectedQuery) {
          if (runQuery) {
            return {
              score: 0,
              comment: 'No custom translation expected, but received'
            };
          }
          return {
            comment: 'No custom translation expected'
          };
        }
        if (!runQuery) {
          return {
            score: 0,
            comment: 'Custom translation expected, but not received'
          };
        }

        // calculate the levenshtein distance between the two queries:
        // The distance is the minimum number of single-character edits required to change one word into the other.
        // So, the distance is a number between 0 and the length of the longest string.
        const queryDistance = (0, _fastestLevenshtein.distance)(runQuery, expectedQuery);
        const maxDistance = Math.max(expectedQuery.length, runQuery.length);
        // The similarity is a number between 0 and 1 (score), where 1 means the two strings are identical.
        const similarity = 1 - queryDistance / maxDistance;
        return {
          score: Math.round(similarity * 1000) / 1000,
          // round to 3 decimal places
          comment: `Distance: ${queryDistance}`
        };
      },
      prebuilt_rule_match: ({
        run,
        example
      }) => {
        var _run$outputs2, _run$outputs2$elastic, _example$outputs2, _example$outputs2$ela;
        const runPrebuiltRuleId = run === null || run === void 0 ? void 0 : (_run$outputs2 = run.outputs) === null || _run$outputs2 === void 0 ? void 0 : (_run$outputs2$elastic = _run$outputs2.elastic_rule) === null || _run$outputs2$elastic === void 0 ? void 0 : _run$outputs2$elastic.prebuilt_rule_id;
        const expectedPrebuiltRuleId = example === null || example === void 0 ? void 0 : (_example$outputs2 = example.outputs) === null || _example$outputs2 === void 0 ? void 0 : (_example$outputs2$ela = _example$outputs2.elastic_rule) === null || _example$outputs2$ela === void 0 ? void 0 : _example$outputs2$ela.prebuilt_rule_id;
        if (!expectedPrebuiltRuleId) {
          if (runPrebuiltRuleId) {
            return {
              score: false,
              comment: 'No prebuilt rule expected, but received'
            };
          }
          return {
            comment: 'No prebuilt rule expected'
          };
        }
        if (!runPrebuiltRuleId) {
          return {
            score: false,
            comment: 'Prebuilt rule expected, but not received'
          };
        }
        if (runPrebuiltRuleId === expectedPrebuiltRuleId) {
          return {
            score: true,
            comment: 'Correct match'
          };
        }
        return {
          score: false,
          comment: `Incorrect match, expected ID is "${expectedPrebuiltRuleId}" but got "${runPrebuiltRuleId}"`
        };
      }
    });
  }
}
exports.RuleMigrationTaskEvaluator = RuleMigrationTaskEvaluator;