"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationsDataDashboardsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _siem_migrations_data_item_client = require("../../common/data/siem_migrations_data_item_client");
var _constants = require("../../../../../common/siem_migrations/constants");
var _dsl_queries = require("./dsl_queries");
var _sort = require("./sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DashboardMigrationsDataDashboardsClient extends _siem_migrations_data_item_client.SiemMigrationsDataItemClient {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "type", 'dashboard');
  }
  getSortOptions(sort = {}) {
    return (0, _sort.getSortingOptions)(sort);
  }
  getFilterQuery(migrationId, filters = {}) {
    var _filters$searchTerm;
    const {
      filter
    } = super.getFilterQuery(migrationId, filters).bool;
    if ((_filters$searchTerm = filters.searchTerm) !== null && _filters$searchTerm !== void 0 && _filters$searchTerm.length) {
      filter.push(_dsl_queries.dsl.matchTitle(filters.searchTerm));
    }
    if (filters.installed != null) {
      filter.push(filters.installed ? _dsl_queries.dsl.isInstalled() : _dsl_queries.dsl.isNotInstalled());
    }
    if (filters.installable != null) {
      filter.push(filters.installable ? _dsl_queries.dsl.isInstallable() : _dsl_queries.dsl.isNotInstallable());
    }
    return {
      bool: {
        filter
      }
    };
  }

  /** Retrieves the translation stats for the dashboard migrations with the provided id */
  async getTranslationStats(migrationId) {
    var _result$aggregations, _doc_count, _doc_count2, _successAgg$installab, _doc_count3, _aggs$failed;
    const index = await this.getIndexName();
    const query = this.getFilterQuery(migrationId);
    const aggregations = {
      success: {
        filter: {
          term: {
            status: _constants.SiemMigrationStatus.COMPLETED
          }
        },
        aggs: {
          result: {
            terms: {
              field: 'translation_result'
            }
          },
          installable: {
            filter: _dsl_queries.dsl.isInstallable()
          }
        }
      },
      failed: {
        filter: {
          term: {
            status: _constants.SiemMigrationStatus.FAILED
          }
        }
      }
    };
    const result = await this.esClient.search({
      index,
      query,
      aggregations,
      _source: false
    }).catch(error => {
      this.logger.error(`Error getting dashboard migrations stats: ${error.message}`);
      throw error;
    });
    const aggs = (_result$aggregations = result.aggregations) !== null && _result$aggregations !== void 0 ? _result$aggregations : {};
    const total = this.getTotalHits(result);
    const successAgg = aggs.success;
    const translationResultsAgg = successAgg.result;
    return {
      id: migrationId,
      dashboards: {
        total,
        success: {
          total: (_doc_count = successAgg === null || successAgg === void 0 ? void 0 : successAgg.doc_count) !== null && _doc_count !== void 0 ? _doc_count : 0,
          result: this.translationResultAggCount(translationResultsAgg),
          installable: (_doc_count2 = (_successAgg$installab = successAgg.installable) === null || _successAgg$installab === void 0 ? void 0 : _successAgg$installab.doc_count) !== null && _doc_count2 !== void 0 ? _doc_count2 : 0
        },
        failed: (_doc_count3 = (_aggs$failed = aggs.failed) === null || _aggs$failed === void 0 ? void 0 : _aggs$failed.doc_count) !== null && _doc_count3 !== void 0 ? _doc_count3 : 0
      }
    };
  }
}
exports.DashboardMigrationsDataDashboardsClient = DashboardMigrationsDataDashboardsClient;