"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateAssistantComment = exports.cleanMarkdown = void 0;
var _constants = require("../../../../../../common/siem_migrations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cleanMarkdown = markdown => {
  // Use languages known by the code block plugin
  return markdown.replaceAll('```esql', '```sql').replaceAll('```spl', '```splunk-spl');
};
exports.cleanMarkdown = cleanMarkdown;
const generateAssistantComment = message => {
  return {
    message,
    created_at: new Date().toISOString(),
    created_by: _constants.SIEM_MIGRATIONS_ASSISTANT_USER
  };
};
exports.generateAssistantComment = generateAssistantComment;