"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskEngineConfigurationTypeName = exports.riskEngineConfigurationTypeMappings = exports.riskEngineConfigurationType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskEngineConfigurationTypeName = exports.riskEngineConfigurationTypeName = 'risk-engine-configuration';
const riskEngineConfigurationTypeMappings = exports.riskEngineConfigurationTypeMappings = {
  dynamic: false,
  properties: {
    dataViewId: {
      type: 'keyword'
    },
    enabled: {
      type: 'boolean'
    },
    filter: {
      dynamic: false,
      properties: {}
    },
    identifierType: {
      type: 'keyword'
    },
    interval: {
      type: 'keyword'
    },
    pageSize: {
      type: 'integer'
    },
    alertSampleSizePerShard: {
      type: 'integer'
    },
    enableResetToZero: {
      type: 'boolean'
    },
    range: {
      properties: {
        start: {
          type: 'keyword'
        },
        end: {
          type: 'keyword'
        }
      }
    },
    excludeAlertStatuses: {
      type: 'keyword'
    }
  }
};
const version1 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      alertSampleSizePerShard: {
        type: 'integer'
      }
    }
  }]
};
const version2 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      excludeAlertStatuses: {
        type: 'keyword'
      }
    }
  }, {
    type: 'data_backfill',
    backfillFn: document => {
      return {
        attributes: {
          ...document.attributes,
          excludeAlertStatuses: document.attributes.excludeAlertStatuses || ['closed']
        }
      };
    }
  }]
};
const version3 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      enableResetToZero: {
        type: 'boolean'
      }
    }
  }, {
    type: 'data_backfill',
    backfillFn: document => {
      return {
        attributes: {
          ...document.attributes,
          enableResetToZero: false
        }
      };
    }
  }]
};
const riskEngineConfigurationType = exports.riskEngineConfigurationType = {
  name: riskEngineConfigurationTypeName,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: riskEngineConfigurationTypeMappings,
  modelVersions: {
    1: version1,
    2: version2,
    3: version3
  }
};