"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUpdatesComponentTemplate = buildUpdatesComponentTemplate;
exports.getEntityUpdatesIndexComponentTemplateStatus = exports.deleteEntityUpdatesIndexComponentTemplate = exports.createEntityUpdatesIndexComponentTemplate = void 0;
var _entity_store = require("../../../../../common/api/entity_analytics/entity_store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_MAPPINGS = {
  '@timestamp': {
    type: 'date'
  }
};
const FIELDS_TO_IGNORE = ['_index'];
const getComponentTemplateName = definitionId => `${definitionId}-updates@platform`;
const createEntityUpdatesIndexComponentTemplate = (description, esClient) => {
  return esClient.cluster.putComponentTemplate(buildUpdatesComponentTemplate(description));
};
exports.createEntityUpdatesIndexComponentTemplate = createEntityUpdatesIndexComponentTemplate;
const deleteEntityUpdatesIndexComponentTemplate = (description, esClient) => {
  return esClient.cluster.deleteComponentTemplate({
    name: getComponentTemplateName(description.id)
  }, {
    ignore: [404]
  });
};
exports.deleteEntityUpdatesIndexComponentTemplate = deleteEntityUpdatesIndexComponentTemplate;
function buildUpdatesComponentTemplate(description) {
  return {
    name: getComponentTemplateName(description.id),
    template: {
      settings: {
        hidden: true
      },
      mappings: buildMappings(description)
    }
  };
}
function buildMappings({
  fields,
  identityField,
  identityFieldMapping
}) {
  const properties = {};
  for (let i = 0; i < fields.length; i++) {
    const field = fields[i];
    if (shouldMapField(field)) {
      properties[field.source] = field.mapping;
    }
  }
  properties[identityField] = identityFieldMapping;
  return {
    properties: {
      ...DEFAULT_MAPPINGS,
      ...properties
    }
  };
}
function shouldMapField(field) {
  return FIELDS_TO_IGNORE.indexOf(field.source) < 0;
}
const getEntityUpdatesIndexComponentTemplateStatus = async (definitionId, esClient) => {
  var _componentTemplate$co;
  const name = getComponentTemplateName(definitionId);
  const componentTemplate = await esClient.cluster.getComponentTemplate({
    name
  }, {
    ignore: [404]
  });
  return {
    id: name,
    installed: (componentTemplate === null || componentTemplate === void 0 ? void 0 : (_componentTemplate$co = componentTemplate.component_templates) === null || _componentTemplate$co === void 0 ? void 0 : _componentTemplate$co.length) > 0,
    resource: _entity_store.EngineComponentResourceEnum.component_template
  };
};
exports.getEntityUpdatesIndexComponentTemplateStatus = getEntityUpdatesIndexComponentTemplateStatus;