"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPromiseFromRuleImportStream = void 0;
var _utils = require("@kbn/utils");
var _create_rules_stream_from_ndjson = require("./create_rules_stream_from_ndjson");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Utility for generating a promise from a Readable stream corresponding to an
 * NDJSON file. Used during rule import.
 */
const createPromiseFromRuleImportStream = ({
  objectLimit,
  stream
}) => {
  const readAllStream = (0, _create_rules_stream_from_ndjson.createRulesAndExceptionsStreamFromNdJson)(objectLimit);
  return (0, _utils.createPromiseFromStreams)([stream, ...readAllStream]);
};
exports.createPromiseFromRuleImportStream = createPromiseFromRuleImportStream;