"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRuleManagementRoutes = void 0;
var _route = require("./rules/bulk_actions/route");
var _route2 = require("./rules/create_rule/route");
var _route3 = require("./rules/delete_rule/route");
var _route4 = require("./rules/export_rules/route");
var _route5 = require("./rules/find_rules/route");
var _route6 = require("./rules/import_rules/route");
var _route7 = require("./rules/filters/route");
var _route8 = require("./rules/patch_rule/route");
var _route9 = require("./rules/read_rule/route");
var _route10 = require("./rules/update_rule/route");
var _route11 = require("./tags/read_tags/route");
var _route12 = require("./rules/coverage_overview/route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRuleManagementRoutes = (router, config, ml, logger) => {
  // Rules CRUD
  (0, _route2.createRuleRoute)(router);
  (0, _route9.readRuleRoute)(router, logger);
  (0, _route10.updateRuleRoute)(router);
  (0, _route8.patchRuleRoute)(router);
  (0, _route3.deleteRuleRoute)(router);

  // Rules bulk actions
  (0, _route.performBulkActionRoute)(router, ml, config);

  // Rules export/import
  (0, _route4.exportRulesRoute)(router, config, logger);
  (0, _route6.importRulesRoute)(router, config, logger);

  // Rules search
  (0, _route5.findRulesRoute)(router, logger);

  // Rule tags
  (0, _route11.readTagsRoute)(router);

  // Rules filters
  (0, _route7.getRuleManagementFilters)(router);

  // Rules coverage overview
  (0, _route12.getCoverageOverviewRoute)(router);
};
exports.registerRuleManagementRoutes = registerRuleManagementRoutes;