"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bootstrapPrebuiltRulesRoute = void 0;
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _constants = require("../../constants");
var _bootstrap_prebuilt_rules_handler = require("./bootstrap_prebuilt_rules_handler");
var _throttle_requests = require("../../../../../utils/throttle_requests");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bootstrapPrebuiltRulesRoute = (router, logger) => {
  router.versioned.post({
    access: 'internal',
    path: _prebuilt_rules.BOOTSTRAP_PREBUILT_RULES_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      timeout: {
        idleSocket: _constants.PREBUILT_RULES_OPERATION_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, (0, _throttle_requests.throttleRequests)((context, request, response) => {
    return (0, _bootstrap_prebuilt_rules_handler.bootstrapPrebuiltRulesHandler)(context, request, response, logger);
  }));
};
exports.bootstrapPrebuiltRulesRoute = bootstrapPrebuiltRulesRoute;