"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexAliasPerSpace = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves index, its alias and Kibana space
 */
const getIndexAliasPerSpace = async ({
  esClient,
  signalsIndex,
  signalsAliasAllSpaces
}) => {
  const response = await esClient.indices.getAlias({
    name: signalsAliasAllSpaces
  }, {
    meta: true
  });
  const indexAliasesMap = Object.keys(response.body).reduce((acc, indexName) => {
    if (!indexName.startsWith('.internal.alerts-')) {
      const alias = Object.keys(response.body[indexName].aliases)[0];
      acc[indexName] = {
        alias,
        space: alias.replace(`${signalsIndex}-`, ''),
        indexName
      };
    }
    return acc;
  }, {});
  return indexAliasesMap;
};
exports.getIndexAliasPerSpace = getIndexAliasPerSpace;