"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAssetCriticalityAggs = exports.getAssetCriticalityStats = void 0;
var _helper = require("../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parses aggregation buckets into a simplified list of entity stats.
 */
const parseAssetCriticalityAggs = response => {
  return response.buckets.map(bucket => ({
    criticality: bucket.key,
    doc_count: bucket.doc_count,
    last_doc_timestamp: bucket.last_doc_timestamp.value_as_string
  }));
};

/**
 * Queries Elasticsearch for entity type stats, parses, and returns them.
 */
exports.parseAssetCriticalityAggs = parseAssetCriticalityAggs;
const getAssetCriticalityStats = async (esClient, logger) => {
  try {
    var _assetCriticalityStat, _assetCriticalityStat2, _assetCriticalityStat3;
    const isIndexExists = await esClient.indices.exists({
      index: _helper.ENTITY_INDEX
    });
    if (!isIndexExists) {
      logger.debug(`Index ${_helper.ENTITY_INDEX} does not exist.`);
      return [];
    }
    const assetCriticalityStats = await esClient.search((0, _helper.getAggsQuery)('asset.criticality', 10));
    const buckets = (_assetCriticalityStat = (_assetCriticalityStat2 = assetCriticalityStats.aggregations) === null || _assetCriticalityStat2 === void 0 ? void 0 : (_assetCriticalityStat3 = _assetCriticalityStat2.field_terms) === null || _assetCriticalityStat3 === void 0 ? void 0 : _assetCriticalityStat3.buckets) !== null && _assetCriticalityStat !== void 0 ? _assetCriticalityStat : [];
    return parseAssetCriticalityAggs({
      buckets
    });
  } catch (e) {
    logger.error(`Failed to get asset criticality stats: ${e instanceof Error ? e.message : String(e)}`);
    return [];
  }
};
exports.getAssetCriticalityStats = getAssetCriticalityStats;