"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.responseActionsWithLegacyActionProperty = exports.ALLOWED_ACTION_REQUEST_TAGS = exports.ACTION_RESPONSE_INDICES = exports.ACTION_REQUEST_INDICES = exports.ACTIONS_SEARCH_PAGE_SIZE = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The Page Size to be used when searching against the Actions indexes (both requests and responses)
 */
const ACTIONS_SEARCH_PAGE_SIZE = exports.ACTIONS_SEARCH_PAGE_SIZE = 10000;
const ACTION_REQUEST_INDICES = exports.ACTION_REQUEST_INDICES = [_common.AGENT_ACTIONS_INDEX, _constants.ENDPOINT_ACTIONS_INDEX];
// search all responses indices irrelevant of namespace
const ACTION_RESPONSE_INDICES = exports.ACTION_RESPONSE_INDICES = [_common.AGENT_ACTIONS_RESULTS_INDEX, _constants.ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN];

/** Legacy API"s that should still return `action` (the action id) in the response */
const responseActionsWithLegacyActionProperty = exports.responseActionsWithLegacyActionProperty = ['isolate', 'unisolate'];

/**
 * The list of `tags` that can be used on an Action Request document
 */
const ALLOWED_ACTION_REQUEST_TAGS = exports.ALLOWED_ACTION_REQUEST_TAGS = Object.freeze({
  // introduced with space awareness. Indicates that response action is currently associated with
  // an integration policy that no longer exists.
  integrationPolicyDeleted: 'INTEGRATION-POLICY-DELETED'
});