"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBuildUnvalidatedReportFromLastMessageNode = void 0;
var _langgraph = require("@langchain/langgraph");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBuildUnvalidatedReportFromLastMessageNode = () => {
  return async state => {
    const {
      messages
    } = state;
    const lastMessage = messages[messages.length - 1];
    return new _langgraph.Command({
      update: {
        messages: [`${(0, _utils.lastMessageWithUnvalidatedReport)(lastMessage.content).content}\n\n` + 'I was unable to generate a ESQL query matching your specification. In your final response include this warning: \n\n"The resulting query was generated as a best effort example, but I am unable to validate it. To help generate a valid query, please provide the name of the index and fields that should be used in the query."\n\n Do not modify query any further.']
      }
    });
  };
};
exports.getBuildUnvalidatedReportFromLastMessageNode = getBuildUnvalidatedReportFromLastMessageNode;