"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelinesPage = exports.DEFAULT_SEARCH_RESULTS_PER_PAGE = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _new_timeline = require("../components/new_timeline");
var _timeline = require("../../../common/api/timeline");
var _header_page = require("../../common/components/header_page");
var _page_wrapper = require("../../common/components/page_wrapper");
var _user_privileges = require("../../common/components/user_privileges");
var _open_timeline = require("../components/open_timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../app/types");
var _empty_prompt = require("../../common/components/empty_prompt");
var _security_route_page_wrapper = require("../../common/components/security_route_page_wrapper");
var _constants = require("../../data_view_manager/constants");
var _containers = require("../../sourcerer/containers");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _page_loader = require("../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/pages/timelines_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_SEARCH_RESULTS_PER_PAGE = exports.DEFAULT_SEARCH_RESULTS_PER_PAGE = 10;
const TimelinesPage = exports.TimelinesPage = /*#__PURE__*/_react.default.memo(() => {
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    indicesExist: oldIndicesExist
  } = (0, _containers.useSourcererDataView)();
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)(_constants.DataViewManagerScopeName.default);
  const experimentalIndicesExist = dataView === null || dataView === void 0 ? void 0 : dataView.hasMatchedIndices();
  const indicesExist = newDataViewPickerEnabled ? experimentalIndicesExist : oldIndicesExist;
  const {
    timelinePrivileges: {
      crud: canWriteTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const [isImportDataModalOpen, setImportDataModal] = (0, _react.useState)(false);
  const openImportModal = (0, _react.useCallback)(() => {
    setImportDataModal(true);
  }, [setImportDataModal]);
  const timelineType = tabName === _timeline.TimelineTypeEnum.default ? _timeline.TimelineTypeEnum.default : _timeline.TimelineTypeEnum.template;
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_security_route_page_wrapper.SecurityRoutePageWrapper, {
    pageName: _types.SecurityPageName.timelines,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, indicesExist ? /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, canWriteTimeline && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "indexOpen",
    onClick: openImportModal,
    "data-test-subj": "timelines-page-open-import-data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 19
    }
  }, i18n.ALL_TIMELINES_IMPORT_TIMELINE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "timelines-page-new",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_new_timeline.NewTimelineButton, {
    type: timelineType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_open_timeline.StatefulOpenTimeline, {
    defaultPageSize: DEFAULT_SEARCH_RESULTS_PER_PAGE,
    isModal: false,
    importDataModalToggle: isImportDataModalOpen && canWriteTimeline,
    setImportDataModalToggle: setImportDataModal,
    title: i18n.ALL_TIMELINES_PANEL_TITLE,
    "data-test-subj": "stateful-open-timeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }));
});
TimelinesPage.displayName = 'TimelinesPage';