"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParentProcessDraggable = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/parent_process_draggable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ParentProcessDraggable = exports.ParentProcessDraggable = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgameParentProcessName,
  eventId,
  processParentName,
  processParentPid,
  processPpid,
  text,
  scopeId
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(processParentName) && (0, _helpers.isNillEmptyOrNotFinite)(endgameParentProcessName)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(text) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    "data-test-subj": "parent-process-draggable-text",
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, text), !(0, _helpers.isNillEmptyOrNotFinite)(processParentName) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.parent.name",
    value: processParentName,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  })), !(0, _helpers.isNillEmptyOrNotFinite)(endgameParentProcessName) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "endgame.parent_process_name",
    value: endgameParentProcessName,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  })), !(0, _helpers.isNillEmptyOrNotFinite)(processParentPid) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.parent.pid",
    queryValue: String(processParentPid),
    value: `(${String(processParentPid)})`,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  })), !(0, _helpers.isNillEmptyOrNotFinite)(processPpid) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.ppid",
    queryValue: String(processPpid),
    value: `(${String(processPpid)})`,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  })));
});
ParentProcessDraggable.displayName = 'ParentProcessDraggable';