"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasThreatMatchValue = exports.HorizontalSpacer = void 0;
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../../../../../../../common/cti/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndicatorEcs = data => {
  const threatData = (0, _lodash.get)(data, _constants.ENRICHMENT_DESTINATION_PATH);
  if (threatData == null) {
    return [];
  } else if (!Array.isArray(threatData)) {
    return [threatData];
  }
  // @ts-expect-error the returned type is ThreatEnrichmentEcs[]
  return threatData;
};
const hasThreatMatchValue = data => getIndicatorEcs(data).some(indicator => _constants2.INDICATOR_MATCH_SUBFIELDS.some(indicatorMatchSubField => !(0, _lodash.isEmpty)((0, _lodash.get)(indicator, indicatorMatchSubField))));
exports.hasThreatMatchValue = hasThreatMatchValue;
const HorizontalSpacer = exports.HorizontalSpacer = _styledComponents.default.div`
  margin: 0 ${({
  theme
}) => theme.eui.euiSizeXS};
`;