"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveTimelineButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _timeline = require("../../../../../common/api/timeline");
var _user_privileges = require("../../../../common/components/user_privileges");
var _save_timeline_modal = require("./save_timeline_modal");
var i18n = _interopRequireWildcard(require("./translations"));
var _selectors = require("../../../store/selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/modal/actions/save_timeline_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Button that allows user to save the timeline. Clicking it opens the `SaveTimelineModal`.
 * The default 'Save' button text can be overridden by passing the `buttonText` prop.
 */
const SaveTimelineButton = exports.SaveTimelineButton = /*#__PURE__*/_react.default.memo(({
  timelineId,
  buttonText = i18n.SAVE,
  buttonColor = 'primary',
  'data-test-subj': dataTestSubj = 'timeline-modal-save-timeline'
}) => {
  const [showEditTimelineOverlay, setShowEditTimelineOverlay] = (0, _react.useState)(false);
  const toggleSaveTimeline = (0, _react.useCallback)(() => setShowEditTimelineOverlay(prev => !prev), []);

  // Case: 1
  // check if user has crud privileges so that user can be allowed to edit the timeline
  // Case: 2
  // TODO: User may have Crud privileges but they may not have access to timeline index.
  // Do we need to check that?
  const {
    timelinePrivileges: {
      crud: canEditTimelinePrivilege
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    status,
    isSaving
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const canSaveTimeline = canEditTimelinePrivilege && status !== _timeline.TimelineStatusEnum.immutable;
  const isUnsaved = status === _timeline.TimelineStatusEnum.draft;
  const unauthorizedMessage = canSaveTimeline ? null : i18n.CALL_OUT_UNAUTHORIZED_MSG;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: unauthorizedMessage,
    position: "bottom",
    "data-test-subj": "timeline-modal-save-timeline-tooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "s",
    color: buttonColor,
    iconType: "save",
    isLoading: isSaving,
    disabled: !canSaveTimeline,
    "data-test-subj": dataTestSubj,
    onClick: toggleSaveTimeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, buttonText)), showEditTimelineOverlay && canSaveTimeline ? /*#__PURE__*/_react.default.createElement(_save_timeline_modal.SaveTimelineModal, {
    initialFocusOn: isUnsaved ? 'title' : 'save',
    timelineId: timelineId,
    showWarning: false,
    closeSaveTimeline: toggleSaveTimeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }) : null);
});
SaveTimelineButton.displayName = 'SaveTimelineButton';