"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TLS_SERVER_CERTIFICATE_FINGERPRINT_SHA1_FIELD_NAME = exports.TLS_CLIENT_CERTIFICATE_FINGERPRINT_SHA1_FIELD_NAME = exports.CertificateFingerprint = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../common/components/draggables");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/certificate_fingerprint/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TLS_CLIENT_CERTIFICATE_FINGERPRINT_SHA1_FIELD_NAME = exports.TLS_CLIENT_CERTIFICATE_FINGERPRINT_SHA1_FIELD_NAME = 'tls.client_certificate.fingerprint.sha1';
const TLS_SERVER_CERTIFICATE_FINGERPRINT_SHA1_FIELD_NAME = exports.TLS_SERVER_CERTIFICATE_FINGERPRINT_SHA1_FIELD_NAME = 'tls.server_certificate.fingerprint.sha1';
const FingerprintLabel = _styledComponents.default.span`
  margin-right: 5px;
`;
FingerprintLabel.displayName = 'FingerprintLabel';

/**
 * Represents a field containing a certificate fingerprint (e.g. a sha1), with
 * a link to an external site, which in-turn compares the fingerprint against a
 * set of known fingerprints
 * Examples:
 * 'tls.client_certificate.fingerprint.sha1'
 * 'tls.server_certificate.fingerprint.sha1'
 */
const CertificateFingerprint = exports.CertificateFingerprint = /*#__PURE__*/_react.default.memo(({
  eventId,
  certificateType,
  contextId,
  fieldName,
  value,
  scopeId
}) => {
  return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    "data-test-subj": `${certificateType}-certificate-fingerprint`,
    eventId: eventId,
    field: fieldName,
    iconType: "snowflake",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }, fieldName)),
    value: value,
    isAggregatable: true,
    fieldType: "keyword",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FingerprintLabel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, certificateType === 'client' ? i18n.CLIENT_CERT : i18n.SERVER_CERT), /*#__PURE__*/_react.default.createElement(_links.CertificateFingerprintLink, {
    certificateFingerprint: value || '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
});
CertificateFingerprint.displayName = 'CertificateFingerprint';