"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFlyoutJson = exports.FLYOUT_JSON_TEST_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _empty_prompt = require("./empty_prompt");
var _json_tab = require("../../../../../flyout/shared/components/json_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/flyout/json_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FLYOUT_JSON_TEST_ID = exports.FLYOUT_JSON_TEST_ID = 'indicators-flyout';
/**
 * Displays all the properties and values of an {@link Indicator} in json view,
 * using the {@link EuiCodeBlock} from the @elastic/eui library.
 */
const IndicatorsFlyoutJson = ({
  indicator
}) => {
  return Object.keys(indicator).length === 0 ? /*#__PURE__*/_react.default.createElement(_empty_prompt.IndicatorEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_json_tab.JsonTab, {
    value: indicator,
    showFooterOffset: false,
    "data-test-subj": FLYOUT_JSON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
};
exports.IndicatorsFlyoutJson = IndicatorsFlyoutJson;