"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpsertResources = exports.RULES_DATA_INPUT_UPSERT_MIGRATION_RESOURCES_ERROR = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _service = require("../../../common/service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULES_DATA_INPUT_UPSERT_MIGRATION_RESOURCES_ERROR = exports.RULES_DATA_INPUT_UPSERT_MIGRATION_RESOURCES_ERROR = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.service.upsertRuleMigrationResourcesError', {
  defaultMessage: 'Failed to upload rule migration resources'
});
const useUpsertResources = onSuccess => {
  const {
    siemMigrations,
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const [state, dispatch] = (0, _react.useReducer)(_service.reducer, _service.initialState);
  const upsertResources = (0, _react.useCallback)((migrationId, data) => {
    (async () => {
      try {
        dispatch({
          type: 'start'
        });
        await siemMigrations.rules.upsertMigrationResources(migrationId, data);
        onSuccess(data);
        dispatch({
          type: 'success'
        });
      } catch (err) {
        var _err$body;
        const apiError = (_err$body = err.body) !== null && _err$body !== void 0 ? _err$body : err;
        notifications.toasts.addError(apiError, {
          title: RULES_DATA_INPUT_UPSERT_MIGRATION_RESOURCES_ERROR
        });
        dispatch({
          type: 'error',
          error: apiError
        });
      }
    })();
  }, [siemMigrations.rules, notifications.toasts, onSuccess]);
  return {
    isLoading: state.loading,
    error: state.error,
    upsertResources
  };
};
exports.useUpsertResources = useUpsertResources;