"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationRulesPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/siem_migrations/constants");
var _kibana = require("../../../common/lib/kibana");
var _header_page = require("../../../common/components/header_page");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _types = require("../../../app/types");
var _rules_table = require("../components/rules_table");
var _need_admin_for_update_rules_callout = require("../../../detection_engine/rule_management/components/callouts/need_admin_for_update_rules_callout");
var _missing_privileges_callout = require("./missing_privileges_callout");
var _components = require("../../common/components");
var _use_latest_stats = require("../service/hooks/use_latest_stats");
var _data_input_wrapper = require("../components/data_input_flyout/data_input_wrapper");
var _migration_ready_panel = require("../components/migration_status_panels/migration_ready_panel");
var _migration_progress_panel = require("../../common/components/migration_panels/migration_progress_panel");
var _use_get_migration_rules = require("../logic/use_get_migration_rules");
var _use_get_migration_translation_stats = require("../logic/use_get_migration_translation_stats");
var _use_get_integrations = require("../service/hooks/use_get_integrations");
var _upload_missing_panel = require("../components/migration_status_panels/upload_missing_panel");
var _empty = require("./empty");
var i18n = _interopRequireWildcard(require("./translations"));
var _page_title = require("../../common/components/page_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/pages/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MigrationRulesPage = exports.MigrationRulesPage = /*#__PURE__*/_react.default.memo(({
  match: {
    params: {
      migrationId
    }
  }
}) => {
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  const {
    data,
    isLoading,
    refreshStats
  } = (0, _use_latest_stats.useLatestStats)();
  const ruleMigrationsStats = (0, _react.useMemo)(() => data.slice().reverse(), [data]); // Show the most recent migration first

  const [integrations, setIntegrations] = _react.default.useState();
  const {
    getIntegrations,
    isLoading: isIntegrationsLoading
  } = (0, _use_get_integrations.useGetIntegrations)(setIntegrations);
  (0, _react.useEffect)(() => {
    getIntegrations();
  }, [getIntegrations]);
  (0, _react.useEffect)(() => {
    if (isLoading || ruleMigrationsStats.length === 0) {
      return;
    }

    // Navigate to the most recent migration if none is selected
    if (!migrationId) {
      navigateTo({
        deepLinkId: _types.SecurityPageName.siemMigrationsRules,
        path: ruleMigrationsStats[0].id
      });
    }
  }, [isLoading, migrationId, navigateTo, ruleMigrationsStats]);
  const onMigrationIdChange = selectedId => {
    navigateTo({
      deepLinkId: _types.SecurityPageName.siemMigrationsRules,
      path: selectedId
    });
  };
  const invalidateGetRuleMigrations = (0, _use_get_migration_rules.useInvalidateGetMigrationRules)();
  const invalidateGetMigrationTranslationStats = (0, _use_get_migration_translation_stats.useInvalidateGetMigrationTranslationStats)();
  const refetchData = (0, _react.useCallback)(() => {
    if (!migrationId) {
      return;
    }
    refreshStats();
    invalidateGetRuleMigrations(migrationId);
    invalidateGetMigrationTranslationStats(migrationId);
  }, [invalidateGetMigrationTranslationStats, invalidateGetRuleMigrations, migrationId, refreshStats]);
  const content = (0, _react.useMemo)(() => {
    if (ruleMigrationsStats.length === 0 && !migrationId) {
      return /*#__PURE__*/_react.default.createElement(_empty.EmptyMigrationRulesPage, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 16
        }
      });
    }
    const migrationStats = ruleMigrationsStats.find(stats => stats.id === migrationId);
    if (!migrationId || !migrationStats) {
      return /*#__PURE__*/_react.default.createElement(_components.UnknownMigration, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 16
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_data_input_wrapper.RuleMigrationDataInputWrapper, {
      onFlyoutClosed: refetchData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, migrationStats.status === _constants.SiemMigrationTaskStatus.FINISHED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_upload_missing_panel.RuleMigrationsUploadMissingPanel, {
      migrationStats: migrationStats,
      topSpacerSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_rules_table.MigrationRulesTable, {
      refetchData: refetchData,
      integrations: integrations,
      isIntegrationsLoading: isIntegrationsLoading,
      migrationStats: migrationStats,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 17
      }
    })), [_constants.SiemMigrationTaskStatus.READY, _constants.SiemMigrationTaskStatus.INTERRUPTED, _constants.SiemMigrationTaskStatus.STOPPED].includes(migrationStats.status) && /*#__PURE__*/_react.default.createElement(_migration_ready_panel.MigrationReadyPanel, {
      migrationStats: migrationStats,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 15
      }
    }), migrationStats.status === _constants.SiemMigrationTaskStatus.RUNNING && /*#__PURE__*/_react.default.createElement(_migration_progress_panel.MigrationProgressPanel, {
      migrationStats: migrationStats,
      migrationType: "rule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 15
      }
    })));
  }, [migrationId, refetchData, ruleMigrationsStats, integrations, isIntegrationsLoading]);
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
      title: i18n.PAGE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 28
      }
    }),
    border: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.HeaderButtons, {
    migrationType: "rule",
    migrationsStats: ruleMigrationsStats,
    selectedMigrationId: migrationId,
    onMigrationIdChange: onMigrationIdChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_need_admin_for_update_rules_callout.NeedAdminForUpdateRulesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_privileges_callout.MissingPrivilegesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    key: migrationId,
    "data-test-subj": "migrationRulesPageLoading",
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 15
      }
    })),
    loadedContent: content,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }));
});
MigrationRulesPage.displayName = 'MigrationRulesPage';