"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _missing_privileges = require("../../../../common/components/missing_privileges");
var _bulk_actions = require("../../../../common/components/bulk_actions");
var _update_missing_index = require("./update_missing_index");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table/bulk_actions/bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReprocessFailedRulesButton = (0, _missing_privileges.WithMissingPrivilegesTooltip)(_bulk_actions.ReprocessFailedItemsButton, 'rule', 'all');
/**
 * Collection of buttons to perform bulk actions on migration rules within the SIEM Rules Migrations table.
 */
const BulkActions = exports.BulkActions = /*#__PURE__*/(0, _react.memo)(({
  isTableLoading,
  translationStats,
  selectedRules,
  installTranslatedRule,
  installSelectedRule,
  reprocessFailedRules,
  setMissingIndexPatternFlyoutOpen
}) => {
  const numberOfFailedRules = translationStats.rules.failed;
  const numberOfTranslatedRules = translationStats.rules.success.installable;
  const numberOfRulesWithMissingIndex = translationStats.rules.success.missing_index;
  const showInstallSelectedRulesButton = numberOfTranslatedRules > 0;
  const showRetryFailedRulesButton = numberOfFailedRules > 0;
  const showUpdateMissingIndexPatternButton = numberOfRulesWithMissingIndex > 0;
  const reprocessFailedRulesCallback = (0, _react.useCallback)(() => {
    reprocessFailedRules === null || reprocessFailedRules === void 0 ? void 0 : reprocessFailedRules();
  }, [reprocessFailedRules]);
  const installTranslatedRulesCallback = (0, _react.useCallback)(() => {
    installTranslatedRule === null || installTranslatedRule === void 0 ? void 0 : installTranslatedRule();
  }, [installTranslatedRule]);
  const installSelectedRulesCallback = (0, _react.useCallback)(() => {
    installSelectedRule === null || installSelectedRule === void 0 ? void 0 : installSelectedRule();
  }, [installSelectedRule]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true,
    "data-test-subj": "migrationsBulkActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, showUpdateMissingIndexPatternButton && /*#__PURE__*/_react.default.createElement(_update_missing_index.UpdateMissingIndex, {
    setMissingIndexPatternFlyoutOpen: setMissingIndexPatternFlyoutOpen,
    isTableLoading: isTableLoading,
    selectedRules: selectedRules,
    translationStats: translationStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }), showRetryFailedRulesButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(ReprocessFailedRulesButton, {
    isDisabled: isTableLoading,
    isLoading: isTableLoading,
    numberOfFailedItems: numberOfFailedRules,
    onClick: reprocessFailedRulesCallback,
    selectedItems: selectedRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  })), showInstallSelectedRulesButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_bulk_actions.InstallTranslatedButton, {
    disableInstallTranslatedItemsButton: isTableLoading,
    installSelectedItem: installSelectedRulesCallback,
    installTranslatedItems: installTranslatedRulesCallback,
    isLoading: isTableLoading,
    numberOfTranslatedItems: numberOfTranslatedRules,
    selectedItems: selectedRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  })));
});
BulkActions.displayName = 'BulkActions';